function [t,q,dq,ddq]=motion_definition_min_jerk(specs,qini,qd,tf,dt)


%Here it is a straight line motion with minimal jerk

%Flash, Tamar, and Neville Hogan. "The coordination of arm movements: an experimentally confirmed mathematical model." The journal of Neuroscience 5.7 (1985): 1688-1703.
k1=numel(qd(1,:));
Xtarg=zeros(2,k1+1);
qtarg=[qini qd];

for i=1:k1+1
    Xtemp=DK_robot_plan(qtarg(:,i),specs);
    Xtarg(:,i)=Xtemp(:,3);
end

for i=1:k1

if i==1
    t=0:dt:tf(i);
for j=1:numel(t)
X(:,j)=Xtarg(:,i)+(Xtarg(:,i)-Xtarg(:,i+1))*(15*(t(j)/tf(i))^4-6*(t(j)/tf(i))^5-10*(t(j)/tf(i))^3);
end
else
    ttemp1=0:dt:tf(i);
    for j=1:numel(ttemp1)
    Xp(:,j)=Xtarg(:,i)+(Xtarg(:,i)-Xtarg(:,i+1))*(15*(ttemp1(j)/tf(i))^4-6*(ttemp1(j)/tf(i))^5-10*(ttemp1(j)/tf(i))^3);
    end
    [X,t]=concat_motion(X,Xp,t,ttemp1,dt);
end
end
q=zeros(2,numel(t));

q(:,1)=qini;

for i=2:numel(t)

q(2,i)=acos((X(1,i)^2+X(2,i)^2-specs.l1^2-specs.l2^2)/(2*specs.l1*specs.l2));
q(1,i)=atan(X(2,i)/X(1,i))-atan((specs.l2*sin(q(2,i)))/(specs.l1+specs.l2*cos(q(2,i))));

end

dq=derivate_2order(dt,q')';
ddq=derivate_2order(dt,dq')';

end